Rem
Rem $Header: ordim/demo/plsqlwtk/photosidx.sql /main/4 2009/06/05 12:48:28 rabbott Exp $
Rem
Rem photosidx.sql
Rem
Rem Copyright (c) 2005, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      photosidx.sql
Rem
Rem    DESCRIPTION
Rem      Create the text index for the PhotoAlbum demo.
Rem      Schema name is passed in SQL*Plus variable demouser.
Rem
Rem    NOTES
Rem      This script is called by install.sql. Connect as SYSTEM or SYS
Rem      before execution. 
Rem      
Rem    MODIFIED   (MM/DD/YY)
Rem    rabbott     06/05/09 - XbranchMerge rabbott_update_photoalbum_xmlindex
Rem                           from st_ordim_11.2.0.1
Rem    rabbott     06/05/09 - add XMLIndex
Rem    rabbott     05/12/09 - add enquote_name
Rem    rabbott     04/02/07 - Remove CTXXPATH index
Rem    rabbott     03/16/05 - rabbott_update_plsql_photoalbum
Rem    rabbott     03/03/05 - Created
Rem

DECLARE
  pa_schema VARCHAR2(30);
  ctxpref   VARCHAR2(64);
  ctxcols   VARCHAR2(512);
BEGIN
  -- find the current schema
  pa_schema := sys.dbms_assert.enquote_name('&demouser');
  
 -- create preference PA_CTXIDX
 ctxpref := pa_schema || '.PA_CTXIDX';
 ctx_ddl.create_preference( ctxpref, 'MULTI_COLUMN_DATASTORE');

 -- create a multi-column datastore
 ctxcols := 'description, '                   ||
            pa_schema || '.photo_album.getClob(METAIPTC), ' ||
            pa_schema || '.photo_album.getClob(METAEXIF), ' ||
            pa_schema || '.photo_album.getClob(METAXMP), '  ||
            pa_schema || '.photo_album.getClob(METAORDIMAGE)';
 ctx_ddl.set_attribute( ctxpref, 'COLUMNS', ctxcols );

 -- create full text index
 execute immediate 'create  index pa_ctx_idx on photos(description) ' ||
                   'indextype is ctxsys.context ' ||
                   'parameters ( ''DATASTORE ' || ctxpref || ' '') ';

 -- create an XMLIndex over the XML metadata 
 execute immediate 'create index pa_iptc_idx on photos(metaIptc) ' ||
                   'indextype is xdb.xmlindex';
 execute immediate 'create index pa_exif_idx on photos(metaExif) ' ||
                   'indextype is xdb.xmlindex';
 execute immediate 'create index pa_xmp_idx on photos(metaXmp) ' ||
                   'indextype is xdb.xmlindex';

end;
/
